// CCSLocalAttribute
//
//
// REVISION HISTORY:
// Mon May 30 15:34:42 PDT 1994 mo
// Starting point.
//
// DESCRIPTION:
// A kind of attribute which is applied to the current object.

#import "MCAttribute.h"

@interface MCLocalAttribute:NSObject
{
    id		model;
    NSString	*attributeName;
}

// FACTORY METHODS

+ (void)initialize;

// INSTANCE METHODS

- initAttributeNamed:(NSString *)aName forModel:aModel; // DI

// ACCESSOR METHODS

- model;
- (void)setModel:aModel;

// these accessors are for IB inspection only.
- (NSString *)attributeName;
- (void)setAttributeName:(NSString *)aName;

// RETURNING THE ATTRIBUTE TYPE

- (CCSAttributeType)attributeType;

// TESTING THE LEVEL OF SUPPORT FOR THE ATTRIBUTE IN THE MODEL

- (BOOL)isReadable;
- (BOOL)isWritable;
- (BOOL)isReadWritable;

// GETTING AND SETTING VALUES FOR THE ATTRIBUTE

- getValue;
- (void)setValue:aValue;

// TYPED STREAM SUPPORT

- (id)initWithCoder:(NSCoder *)aDecoder;
- (void)encodeWithCoder:(NSCoder *)aCoder;

@end
